/**
 * <p>Contains classes for representing and solving simple constraint
 * satisfaction problems.</p>
 * 
 * <p>It is recommended that you complete this exercise in this order:</p>
 * <ol>
 * <li>Begin by reading the documentation for
 * {@link edu.uky.ai.csp.kr.Problem} and
 * {@link edu.uky.ai.csp.kr.Solution} and considering
 * {@link edu.uky.ai.csp.Solver#solve(edu.uky.ai.csp.kr.Solution) Solver#solve},
 * which has already been written for you.</li>
 * <li>Run {@link edu.uky.ai.csp.Main} on each of the example
 * problems to see how this naive search algorithm performs.</li>
 * <li>Start by filling in
 * {@link edu.uky.ai.csp.Solver#propagate(edu.uky.ai.csp.kr.Solution) propagate},
 * and the three helper methods needed to make it work.</li>
 * <li>Run the example problems again to see how using constraint propagation
 * can be helpful as a pre-processing step. Note that some problems, such as
 * the easy Sudoku, can be solved completely by constraint propagation.</li>
 * <li>Now work on improving the helper methods used by
 * {@link edu.uky.ai.csp.Solver#solve(edu.uky.ai.csp.kr.Solution) solve}
 * and see how each one improves the performance of the algorithm.</li>
 * </ol>
 */
package edu.uky.ai.csp;